;/*************************************************
; Program		:Generate PWM 
; Description	:Timer/Counter1 generates pulse at PWM2 port  
; CPU Control	:ATmega163
; File name		:PWM2.asm
; Assembler		:AVR Studio 4.05
; 
;**************************************************
.include "m163def.inc"			

			.org   	$000 
    		rjmp  reset				;Reset Handle
;/************************
; Define Register
;/************************
.def		temp		= r19
;/*******************
; Main Program
;/*******************
reset:      ldi	temp,low(RAMEND)
            out	SPL,temp          	;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp        	

;/*************************************************
; Timer/Counter1 generates PWM at the PWM1 port
;/*************************************************
PWM1B:		ldi	temp,(1<<COM1B1)|(1<<PWM11)|(1<<PWM10)
			out	TCCR1A,temp			;10 bit PWM1 non-inverted (Fck/2046)
			ldi	temp,(1<<CS12)|(1<<CS10)	;ck/1024
			out	TCCR1B,temp
			ldi	temp,0x03
			out	OCR1BH,temp
			ldi	temp,0x32			;duty cycle = 80% at frequency = 3.8 Hz 
			out	OCR1BL,temp				
			sbi	DDRD,PD4
Loop_PWM1B:	rjmp	Loop_PWM1B		
